/* JOrbis
 * Copyright (C) 2000 ymnk, JCraft,Inc.
 *  
 * Written by: 2000 ymnk<ymnk@jcaft.com>
 *   
 * Many thanks to 
 *   Monty <monty@xiph.org> and 
 *   The XIPHOPHORUS Company http://www.xiph.org/ .
 * JOrbis has been based on their awesome works, Vorbis codec.
 *   
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jorbis;

class ChainingExample{
  public static void main(String[] arg){
    VorbisFile ov=new VorbisFile(System.in, null, -1);

    if(ov.ov_seekable()){
      System.out.println("Input bitstream contained "+ov.ov_streams()+" logical bitstream section(s).");
      System.out.println("Total bitstream playing time: "+ov.ov_time_total(-1)+" seconds\n");
    }
    else{
      System.out.println("Standard input was not seekable.");
      System.out.println("First logical bitstream information:\n");
    }

    for(int i=0;i<ov.ov_streams();i++){
      Info vi=ov.ov_info(i);
      System.out.println("\tlogical bitstream section "+(i+1)+" information:");
      System.out.println("\t\t"+vi.rate+"Hz "+vi.channels+" channels bitrate "+
                         (ov.ov_bitrate(i)/1000)+"kbps serial number="+ov.ov_serialnumber(i));
      System.out.print("\t\tcompressed length: "+ov.ov_raw_total(i)+" bytes ");
      System.out.println(" play time: "+ov.ov_time_total(i)+"s");
      Comment vc=ov.ov_comment(i);
      System.out.println(vc);
    }
    //ov_clear(&ov);
  }
}
