/* JOrbis
 * Copyright (C) 2000 ymnk, JCraft,Inc.
 *  
 * Written by: 2000 ymnk<ymnk@jcaft.com>
 *   
 * Many thanks to 
 *   Monty <monty@xiph.org> and 
 *   The XIPHOPHORUS Company http://www.xiph.org/ .
 * JOrbis has been based on their awesome works, Vorbis codec.
 *   
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jorbis;

import com.jcraft.jogg.*;

// the comments are not part of vorbis_info so that vorbis_info can be
// static storage
public class Comment{
  private static byte[] _vorbis="vorbis".getBytes();

  // unlimited user comment fields.  libvorbis writes 'libvorbis'
  // whatever vendor is set to in encode
  public byte[][] user_comments;
  public int[] comment_lengths; 
  public int    comments;
  public byte[] vendor;

  public void init(){
    user_comments=null;
    comments=0;
    vendor=null;
  }

  public void add(byte[] comment){
    byte[][] foo=new byte[comments+2][];
    if(user_comments!=null)
      System.arraycopy(user_comments, 0, foo, 0, comments);
    user_comments=foo;

    int[] goo=new int[comments+2];
    if(comment_lengths!=null)
      System.arraycopy(comment_lengths, 0, goo, 0, comments);
    comment_lengths=goo;

    byte[] bar=new byte[comment.length];
    System.arraycopy(comment, 0, bar, 0, comment.length);
    user_comments[comments]=bar;
    comment_lengths[comments]=bar.length;
    comments++;
    user_comments[comments]=null;
  }

  void add_tag(byte[] tag, byte[] contents){
    byte[] foo=new byte[tag.length+contents.length+2];
    int j=0; 
    for(int i=0; i<tag.length; i++){foo[j++]=tag[i];}
    foo[j++]=(byte)'='; j++;
    for(int i=0; i<contents.length; i++){foo[j++]=tag[i];}
    add(foo);
  }
 
  // This is more or less the same as strncasecmp - but that doesn't exist
  // * everywhere, and this is a fairly trivial function, so we include it
  static boolean tagcompare(byte[] s1, byte[] s2, int n){
    int c=0;
    byte u1, u2;
    while(c < n){
      u1=s1[c]; u2=s2[c];
      if(u1>='A')u1=(byte)(u1-'A'+'a');
      if(u2>='A')u2=(byte)(u2-'A'+'a');
      if(u1!=u2){ return false; }
      c++;
    }
    return true;
  }

  public byte[] query(byte[] tag, int count){
    int i=0;
    int found = 0;
    int taglen = tag.length;
    byte[] fulltag = new byte[taglen+2];
    System.arraycopy(tag, 0, fulltag, 0, tag.length);
    fulltag[tag.length]=(byte)'=';

    for(i=0;i<comments;i++){
      if(tagcompare(user_comments[i], fulltag, taglen)){
        if(count==found){
 	  // We return a pointer to the data, not a copy
          //return user_comments[i] + taglen + 1;
          return user_comments[i];
	}
        else{ found++; }
      }
    }
    return null;
  }

  int vorbis_unpack_comment(Buffer opb){
    int vendorlen=opb.read(32);
    if(vendorlen<0){
      //goto err_out;
      clear();
      return(-1);
    }
    vendor=new byte[vendorlen+1];
    opb.read(vendor,vendorlen);
    comments=opb.read(32);
    if(comments<0){
      //goto err_out;
      clear();
      return(-1);
    }
    user_comments=new byte[comments+1][];
    comment_lengths=new int[comments+1];
	    
    for(int i=0;i<comments;i++){
      int len=opb.read(32);
      if(len<0){
	//goto err_out;
	clear();
	return(-1);
      }
      comment_lengths[i]=len;
      user_comments[i]=new byte[len+1];
      opb.read(user_comments[i], len);
    }	  
    if(opb.read(1)!=1){
      //goto err_out; // EOP check
      clear();
      return(-1);

    }
    return(0);
//  err_out:
//    vorbis_comment_clear(vc);
//    return(-1);
  }

  int vorbis_pack_comment(Buffer opb){
    byte[] temp="Xiphophorus libVorbis I 20000508".getBytes();

    // preamble
    opb.write(0x03,8);
    opb.write(_vorbis);

    // vendor
    opb.write(temp.length,32);
    opb.write(temp);
  
    // comments

    opb.write(comments,32);
    if(comments!=0){
      for(int i=0;i<comments;i++){
	if(user_comments[i]!=null){
	  opb.write(comment_lengths[i],32);
	  opb.write(user_comments[i]);
	}
	else{
	  opb.write(0,32);
	}
      }
    }
    opb.write(1,1);
    return(0);
  }
 
  void clear(){
    for(int i=0;i<comments;i++)
      user_comments[i]=null;
    user_comments=null;
    vendor=null;
  }

  public String toString(){
    String foo="Vendor: "+new String(vendor, 0, vendor.length-1);
    for(int i=0; i<comments; i++){
      foo=foo+"\nComment: "+new String(user_comments[i], 0, user_comments[i].length-1);
    }
    foo=foo+"\n";
    return foo;
  }
}
