/* JOrbis
 * Copyright (C) 2000 ymnk, JCraft,Inc.
 *  
 * Written by: 2000 ymnk<ymnk@jcaft.com>
 *   
 * Many thanks to 
 *   Monty <monty@xiph.org> and 
 *   The XIPHOPHORUS Company http://www.xiph.org/ .
 * JOrbis has been based on their awesome works, Vorbis codec.
 *   
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package com.jcraft.jorbis;

import com.jcraft.jogg.*;

class Residue0 extends FuncResidue{
  void pack(Object vr, Buffer opb){}
  Object unpack(Info vi, Buffer opb){
    int acc=0;
    InfoResidue0 info=new InfoResidue0();

    info.begin=opb.read(24);
    info.end=opb.read(24);
    info.grouping=opb.read(24)+1;
    info.partitions=opb.read(6)+1;
    info.groupbook=opb.read(8);
    for(int j=0;j<info.partitions;j++){
      acc+=info.secondstages[j]=opb.read(4);
    }
    for(int j=0;j<acc;j++){
      info.booklist[j]=opb.read(8);
      if(info.booklist[j]==255)info.booklist[j]=-1;
    }

    if(info.groupbook>=vi.books){
      free_info(info);
      return(null);
    }
    for(int j=0;j<acc;j++){
      if(info.booklist[j]>=vi.books){
	free_info(info);
	return(null);
      }
    }
    return(info);
//  errout:
//    free_info(info);
//    return(NULL);
  }
  Object look(DspState vd, InfoMode vm, Object vr){
    InfoResidue0 info=(InfoResidue0)vr;
    LookResidue0 look=new LookResidue0();
    int acc=0;
    int dim;
    look.info=info;

    look.parts=info.partitions;
    look.phrasebook=vd.fullbooks[info.groupbook];
    dim=look.phrasebook.dim;

    look.partbooks=new CodeBook[look.parts][];

    for(int j=0;j<look.parts;j++){
      int stages=info.secondstages[j];
      if(stages!=0){
        look.partbooks[j]=new CodeBook[stages];
        look.partbooks[j][0]=vd.fullbooks[info.booklist[acc++]];
      }
    }

    look.partvals=(int)Math.rint(Math.pow(look.parts,dim));
    look.decodemap=new int[look.partvals][];
    for(int j=0;j<look.partvals;j++){
      int val=j;
      int mult=look.partvals/look.parts;
      look.decodemap[j]=new int[dim];
      for(int k=0;k<dim;k++){
        int deco=val/mult;
        val-=deco*mult;
        mult/=look.parts;
        look.decodemap[j][k]=deco;
      }
    }
    return(look);
  }
  void free_info(Object i){}
  void free_look(Object i){}
  int forward(Block vb,Object vl, float[][] in, int ch){
    System.err.println("Residue0.forward: not implemented");
    return 0;
  }

  int inverse(Block vb, Object vl, float[][] in, int ch){
//System.err.println("Residue0.inverse");
    int i,j,k,l,transend=vb.pcmend/2;
    LookResidue0 look=(LookResidue0 )vl;
    InfoResidue0 info=look.info;

    // move all this setup out later
    int samples_per_partition=info.grouping;
    int partitions_per_word=look.phrasebook.dim;
    int n=info.end-info.begin;

    int partvals=n/samples_per_partition;
    int partwords=(partvals+partitions_per_word-1)/partitions_per_word;
    int[][] partword=new int[ch][];
    float[] work=new float[samples_per_partition];
    partvals=partwords*partitions_per_word;

    // make sure we're zeroed up to the start
    for(j=0;j<ch;j++){
      for(k=0; k<info.begin; k++)in[j][k]=0.0f;
    }

    for(i=info.begin,l=0;i<info.end;){
      // fetch the partition word for each channel
      for(j=0;j<ch;j++){
        int temp=look.phrasebook.decode(vb.opb);
        if(temp==-1){
          //goto eopbreak;
          if(i<transend){
            for(j=0;j<ch;j++){
	      for(k=0;k<transend-i;k++)in[j][i+k]=0.0f;
            }
	  }
	  return(0);
	}
        partword[j]=look.decodemap[temp];
        if(partword[j]==null){
          //goto errout;
          for(j=0;j<ch;j++){
            for(k=0;k<transend;k++)in[j][k]=0.0f;
	  }
	  return(0);
	}
      }
    
      // now we decode interleaved residual values for the partitions
      for(k=0;k<partitions_per_word;k++,l++,i+=samples_per_partition){
	for(j=0;j<ch;j++){
	  int part=partword[j][k];
	  if(decodepart(vb.opb,work, in[j], i,samples_per_partition,
			info.secondstages[part],
			look.partbooks[part])==-1){
	    //goto eopbreak;
	    if(i<transend){
	      for(j=0;j<ch;j++){
		for(k=0;k<transend-i;k++)in[j][i+k]=0.0f;
	      }
	    }
	    return(0);
	  }
	}
      }
    }

// eopbreak:
    if(i<transend){
      for(j=0;j<ch;j++){
        for(k=0;k<transend-i;k++)in[j][i+k]=0.0f;
      }
    }
    return(0);

// errout:
//  for(j=0;j<ch;j++)
//    for(k=0;k<transend;k++)in[j][k]=0.0f;
//  return(0);
  }

  static int decodepart(Buffer opb, float[] work, float[] vec, int veci,
			int n, int stages, CodeBook[] books){
    int i,j;
    for(i=0;i<n;i++)work[i]=0.0f;

    for(j=0;j<stages;j++){
      int dim=books[j].dim;
      int step=n/dim;
      for(i=0;i<step;i++){
        if(books[j].decodevs(work, i, opb, step, 0)==-1){
	  return(-1);
	}
      }
    }
    for(i=0;i<n;i++){
      vec[veci+i]*=work[i];
    }
    return(0);
  }
}

class LookResidue0 {
  InfoResidue0 info;
  
  int         parts;
  CodeBook   phrasebook;
  CodeBook[][] partbooks;

  int         partvals;
  int[][]     decodemap;
}

class InfoResidue0{
  // block-partitioned VQ coded straight residue
  int begin;
  int end;

  // first stage (lossless partitioning)
  int grouping;                   // group n vectors per partition
  int partitions;                 // possible codebooks for a partition
  int groupbook;                  // huffbook for partitioning
  int[] secondstages=new int[64]; // expanded out to pointers in lookup
  int[] booklist=new int[256];    // list of second stage books

  // encode-only heuristic settings
  float[] entmax=new float[64];       // book entropy threshholds
  float[] ampmax=new float[64];       // book amp threshholds
  int[] subgrp=new int[64];       // book heuristic subgroup size
  int[] blimit=new int[64];       // subgroup position limits
}
