/*
 * 07/12/2001 - 14:26:30
 *
 * DirtyOggre.java - Dirty sample GUI
 * Copyright (C) 2001 Romain Guy
 * romain.guy@jext.org
 * www.jext.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.jext.oggre.gui;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

import org.jext.oggre.player.Player;
import org.jext.oggre.player.OGGListener;
import org.jext.oggre.playlist.PlayList;
import org.jext.oggre.playlist.PlayListFactory;
import org.jext.oggre.playlist.Song;

public class DirtyOggre extends JFrame implements ActionListener, OGGListener
{
  // player
  private Player player;
  private PlayList playList;

  // gui
  private JCheckBox chkShuffle, chkRepeat;
  private JLabel lblTimer, lblArtist, lblTitle, lblAlbum;
  private JButton btnPrevious, btnPause, btnStop, btnPlay, btnNext;

  // infos
  protected int y = 0;
  protected GridBagLayout gridBag;

  public DirtyOggre(String playListFile)
  {
    super("Dirty OGGre");

    // player
    playList = PlayListFactory.getPlayListFromFile(System.getProperty("user.dir")  +
                                                   java.io.File.separator + playListFile);
    player = new Player(playList);
    player.setOGGListener(this);

    // buttons
    btnPrevious = new JButton("<|");
    btnPause    = new JButton("||");
    btnStop     = new JButton("[]");
    btnPlay     = new JButton(">");
    btnNext     = new JButton("|>");

    // boxes
    chkShuffle = new JCheckBox("Shuffle");
    chkRepeat  = new JCheckBox("Repeat");

    // label
    lblTimer  = new JLabel("00:00");
    lblArtist = new JLabel("/");
    lblTitle  = new JLabel("/");
    lblAlbum  = new JLabel("/");

    // actions
    btnPrevious.addActionListener(this);
    btnPause.addActionListener(this);
    btnStop.addActionListener(this);
    btnPlay.addActionListener(this);
    btnNext.addActionListener(this);

    chkShuffle.addActionListener(this);
    chkRepeat.addActionListener(this);

    // gui
    JPanel infosPanel = new JPanel(gridBag = new GridBagLayout());
    infosPanel.setBackground(Color.black);
    infosPanel.setForeground(Color.green);

    addComponent(infosPanel, "Time : ",   lblTimer);
    addComponent(infosPanel, "Artist : ", lblArtist);
    addComponent(infosPanel, "Title : ",  lblTitle);
    addComponent(infosPanel, "Album : ",  lblAlbum);

    JPanel buttonsPanel = new JPanel();
    buttonsPanel.add(btnPrevious);
    buttonsPanel.add(btnPause);
    buttonsPanel.add(btnStop);
    buttonsPanel.add(btnPlay);
    buttonsPanel.add(btnNext);

    JPanel optionsPanel = new JPanel(new BorderLayout());
    JPanel panel = new JPanel();
    panel.add(chkShuffle);
    panel.add(chkRepeat);
    optionsPanel.add(BorderLayout.WEST, panel);

    JPanel mainPanel = new JPanel(new BorderLayout());
    mainPanel.add(BorderLayout.NORTH,  infosPanel);
    mainPanel.add(BorderLayout.CENTER, buttonsPanel);
    mainPanel.add(BorderLayout.SOUTH,  optionsPanel);
    getContentPane().add(mainPanel);

    // on close
    addWindowListener(new WindowAdapter()
    {
      public void windowClosing(WindowEvent evt)
      {
        playList = null;
        player.stop();
        player = null;

        dispose();
        System.exit(1);
      }
    });

    // misc
    pack();
    setResizable(false);
    setVisible(true);
  }

  protected void addComponent(JPanel pane, String label, Component comp)
  {
    GridBagConstraints cons = new GridBagConstraints();
    cons.gridy = y++;
    cons.gridheight = 1;
    cons.gridwidth = 3;
    cons.fill = GridBagConstraints.BOTH;
    cons.weightx = 1.0f;

    cons.gridx = 0;
    cons.anchor = GridBagConstraints.WEST;
    JLabel l = new JLabel(label, SwingConstants.LEFT);
    l.setBackground(Color.black);
    l.setForeground(Color.green);
    gridBag.setConstraints(l, cons);
    pane.add(l);

    cons.gridx = 3;
    cons.gridwidth = 1;
    cons.anchor = GridBagConstraints.EAST;

    gridBag.setConstraints(comp, cons);
    comp.setBackground(Color.black);
    comp.setForeground(comp.getForeground().brighter());
    pane.add(comp);
  }

  public void actionPerformed(ActionEvent evt)
  {
    Object o = evt.getSource();

    if (o == btnPrevious)
    {
      lblTimer.setText("00:00");
      lblArtist.setText("/");
      lblTitle.setText("/");
      lblAlbum.setText("/");

      player.previous();
    } else if (o == btnPause)
      player.pausePlay();
    else if (o == btnStop)
    {
      player.stopPlay();
      lblTimer.setText("00:00");
    } else if (o == btnPlay) {
      lblTimer.setText("00:00");
      lblArtist.setText("/");
      lblTitle.setText("/");
      lblAlbum.setText("/");

      player.play();
    } else if (o == btnNext) {
      lblTimer.setText("00:00");
      lblArtist.setText("/");
      lblTitle.setText("/");
      lblAlbum.setText("/");

      player.next();
    } else if (o == chkShuffle)
      playList.setShuffleEnabled(chkShuffle.isSelected());
    else if (o == chkRepeat)
      playList.setRepeatEnabled(chkRepeat.isSelected());
  }

  public void error(String errorMessage)
  {
  }

  public void setAlbum(String album)
  {
    lblAlbum.setText(album);
  }

  public void setArtist(String artist)
  {
    lblArtist.setText(artist);
  }

  public void setTitle(String title)
  {
    lblTitle.setText(title);
  }

  public void timeElapsed(int seconds)
  {
    int minutes = (int) seconds / 60;
    seconds %= 60;

    StringBuffer buffer = new StringBuffer(5);
    if (minutes < 10)
      buffer.append('0');
    buffer.append(minutes).append(':');
    if (seconds < 10)
      buffer.append('0');
    buffer.append(seconds);

    lblTimer.setText(buffer.toString());
  }

  public static void main(String[] args)
  {
    new DirtyOggre(args[0]);
  }
}

// End of DirtyOggre.java
