/*
 * 07/12/2001 - 15:28:19
 *
 * OGGListener.java - An OGG listener
 * Copyright (C) 2001 Romain Guy
 * romain.guy@jext.org
 * www.jext.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.jext.oggre.player;

/**
 * A <code>OGGListener</code> is an interface to which the
 * player engine sends informations about current played
 * OGG song.
 * @author Romain Guy
 */

public interface OGGListener
{
  /** Warns user when an error occures. */
  public void error(String errorMessage);
  /** Sets the artists name of the song. May be null. */
  public void setAlbum(String album);
  /** Sets the artists name of the song. May be null. */
  public void setArtist(String artist);
  /** Sets the song title. May be null. */
  public void setTitle(String title);
  /** Sets the time elapsed since the beginning of the song, in seconds. */
  public void timeElapsed(int seconds);
}

// End of OGGListener.java
