/*
 * 07/08/2001 - 18:45:48
 *
 * PlayListFactory.java - Creates a play list from a file
 * Copyright (C) 2001 Romain Guy
 * romain.guy@jext.org
 * www.jext.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.jext.oggre.playlist;

import java.io.*;
import java.util.*;

/**
 * A <code>PlayListFactory</code> is used to creates playlists.
 * Play lists can be created from local files (plain text or XML)
 * or from distant ones (plain text or XML on a web server).
 * @author Romain Guy
 */

public class PlayListFactory
{
  /**
   * Constructs a play list by reading songs datas in a
   * plain text file.
   * @param file The playlist file
   */

  public static PlayList getPlayListFromFile(String file)
  {
    try
    {
      BufferedReader reader = new BufferedReader(new FileReader(file));
      ArrayList songs = new ArrayList();

      String line = null;
      while ((line = reader.readLine()) != null)
      {
        if (line.charAt(0) != '#')
          songs.add(new Song(line));
      }

      Song[] playList = new Song[songs.size()];
      for (int i = 0; i < playList.length; i++)
        playList[i] = (Song) songs.get(i);

      songs = null;
      return new PlayList(playList);

    } catch (Exception e) { }

    return null;
  }
}

// End of PlayListFactory.java
