/*
 * 07/08/2001 - 14:45:25
 *
 * Song.java - Interface for playlist items
 * Copyright (C) 2001 Romain Guy
 * romain.guy@jext.org
 * www.jext.org
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package org.jext.oggre.playlist;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * A <code>Song</code> object defines a playlist item.
 * @author Romain Guy
 */

public class Song
{
  private String name;
  private URL location;

  /**
   * Creates a new song.
   * @param location An URL to where the song lies
   * @param name The name of the file
   */

  public Song(String locationPath)
  {
    try
    {
      this.location = new URL(locationPath);

      locationPath = location.toString();
      int slashIndex = locationPath.indexOf('/');

      if (slashIndex != -1)
        this.name = locationPath.substring(slashIndex + 1);
      else
        this.name = locationPath;

    } catch (MalformedURLException mue) {
      System.out.println(mue.toString());
    }
  }

  /**
   * Returns the location of the song file under
   * the form of an URL.
   */

  public URL getLocation()
  {
    return location;
  }

  /**
   * Returns the song name.
   */

  public String getName()
  {
    return name;
  }

  /**
   * toString();
   */

  public String toString()
  {
    String locationPath = location.toString();
    StringBuffer buf = new StringBuffer(name.length() + locationPath.length() + 5);
    buf.append('[').append(locationPath).append(" : ").append(name).append(']');
    return buf.toString();
  }
}

// End of Song.java
